<?php
/**
 * Plugin Name: crosspay Payment GateWay
 * Plugin URI: https://www.mtc.ps
 * Description: crosspay Gateway
 * Author: Modern Tech Corp. MTC
 * Author URI: http://mtc.ps
 * Version: 1.0.14
 * Text Domain: crosspay
 * Domain Path: /i18n/languages/
 *
 * Copyright: (c) 2020-2021 MTC , (mtcg@mtcgaza.com) and WooCommerce
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package   crosspay
 * @author    MTC
 * @category  Gateway
 * @copyright Copyright: (c) 2020-2021 MTC Inc, Inc. (mtcg@mtcgaza.com) and WooCommerce
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 *
 * This crosspay gateway.
 */
 
defined( 'ABSPATH' ) or exit;







// Make sure WooCommerce is active
if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	return;
}


/**
 * Add the gateway to WC Available Gateways
 * 
 * @since 1.0.14
 * @param array $gateways all available WC gateways
 * @return array $gateways all WC gateways + offline gateway
 */
function wc_offline_add_to_gateways( $gateways ) {
	$gateways[] = 'WC_Gateway_Offline';
	return $gateways;
}
add_filter( 'woocommerce_payment_gateways', 'wc_offline_add_to_gateways' );






add_action( 'init', 'crosspay_init_internal' );
function crosspay_init_internal()
{
    add_rewrite_rule( 'my-api.php$', 'index.php?crosspay_api=1', 'top' );
}

add_filter( 'query_vars', 'crosspay_query_vars' );
function crosspay_query_vars( $query_vars )
{
    $query_vars[] = 'crosspay_api';
    return $query_vars;
}

add_action( 'parse_request', 'crosspay_parse_request' );
function crosspay_parse_request( &$wp )
{
    if ( array_key_exists( 'crosspay_api', $wp->query_vars ) ) {
        include 'my-api.php';
        exit();
    }
    return;
}


/**
 * Adds plugin page links
 * 
 * @since 1.0.14
 * @param array $links all plugin links
 * @return array $links all plugin links + our custom links (i.e., "Settings")
 */
function wc_offline_gateway_plugin_links( $links ) {

	$plugin_links = array(
		'<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=crosspay_gateway' ) . '">' . __( 'Configure', 'wc-gateway-offline' ) . '</a>'
	);

	return array_merge( $plugin_links, $links );
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wc_offline_gateway_plugin_links' );


/**
 * Offline Payment Gateway
 *
 * Provides an Offline Payment Gateway; mainly for testing purposes.
 * We load it later to ensure WC is loaded first since we're extending it.
 *
 * @class 		WC_Gateway_Offline
 * @extends		WC_Payment_Gateway
 * @version		1.0.14
 * @package		WooCommerce/Classes/Payment
 * @author 		Qedama
 */
add_action( 'plugins_loaded', 'wc_offline_gateway_init', 11 );


















function wc_offline_gateway_init() {

	class WC_Gateway_Offline extends WC_Payment_Gateway {

		/**
		 * Constructor for the gateway.
		 */
		public function __construct() {
	  
			$this->id                 = 'crosspay_gateway';
			$this->icon               = apply_filters('woocommerce_offline_icon', '');
			$this->has_fields         = false;
			$this->method_title       = __( 'crosspay', 'wc-gateway-offline' );
			$this->method_description = __( 'crosspay', 'wc-gateway-offline' );
		  
			// Load the settings.
			$this->init_form_fields();
			$this->init_settings();
		  
			// Define user set variables
			$this->title        = $this->get_option( 'title' );
			$this->description  = $this->get_option( 'description' );
			$this->instructions = $this->get_option( 'instructions', $this->description );
		  
			// Actions
			add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
			add_action( 'woocommerce_thankyou_' . $this->id, array( $this, 'thankyou_page' ) );
		  
			// Customer Emails
			add_action( 'woocommerce_email_before_order_table', array( $this, 'email_instructions' ), 10, 3 );
		}
	
	
		/**
		 * Initialize Gateway Settings Form Fields
		 */
		public function init_form_fields() {
	  
			$this->form_fields = apply_filters( 'crosspay_gateway_form_fields', array(
		  
				'enabled' => array(
					'title'   => __( 'Enable/Disable', 'crosspay_gateway' ),
					'type'    => 'checkbox',
					'label'   => __( 'Enable crosspay Gateway', 'crosspay_gateway' ),
					'default' => 'yes'
				),
				
				'title' => array(
					'title'       => __( 'Title', 'crosspay_gateway' ),
					'type'        => 'text',
					'description' => __( 'crosspayonline.com Gateway', 'wc-gateway-offline' ),
					'default'     => __( 'crosspay Gateway', 'crosspay_gateway' ),
					'desc_tip'    => true,
				),
				
				'description' => array(
					'title'       => __( 'Description', 'crosspay_gateway' ),
					'type'        => 'textarea',
					'description' => __( 'crosspay Gateway', 'wc-gateway-offline' ),
					'default'     => __( 'crosspayonline.com Gateway', 'wc-gateway-offline' ),
					'desc_tip'    => true,
				),
				
				'instructions' => array(
					'title'       => __( 'Instructions', 'wc-gateway-offline' ),
					'type'        => 'textarea',
					'description' => __( 'crosspay Gateway', 'wc-gateway-offline' ),
					'default'     => '',
					'desc_tip'    => true,
				),
			) );
		}
	
	
		/**
		 * Output for the order received page.
		 */
		public function thankyou_page() {
			if ( $this->instructions ) {
				echo wpautop( wptexturize( $this->instructions ) );
			}
		}
	
	
		/**
		 * Add content to the WC emails.
		 *
		 * @access public
		 * @param WC_Order $order
		 * @param bool $sent_to_admin
		 * @param bool $plain_text
		 */
		public function email_instructions( $order, $sent_to_admin, $plain_text = false ) {
		
			if ( $this->instructions && ! $sent_to_admin && $this->id === $order->payment_method && $order->has_status( 'on-hold' ) ) {
				echo wpautop( wptexturize( $this->instructions ) ) . PHP_EOL;
			}
		}
	
	
		/**
		 * Process the payment and return the result
		 *
		 * @param int $order_id
		 * @return array
		 */
		public function process_payment( $order_id ) {
	
			$order = wc_get_order( $order_id );
			//$order2 = new WC_Order( $order_id );
			$total = $order->get_total();
			$total_bill = $total;
            $c_email = $order->billing_email;

            $c_name = $order->billing_first_name . ' ' . $order->billing_last_name ;
			$c_mobile = $order->billing_phone;
			
			$amount = (float) $total; 


			////////////////////
			
			
			

			
			
			
		
         $order_data = $order->get_data(); 
         
         
                    $contact_name = urlencode($to_name);
                    $company_name =urlencode(" ");
                    $website =urlencode("www.omastore.om");
                    $email =$to;
                    $firstname =urlencode($order->billing_first_name);
                    $lastname =urlencode($order->billing_last_name);
                    
                      $reference_number =$order_id;
                      $date =date("Y-m-d");
                      $line_items = urlencode($_REQUEST['line_items']);
                      
                      
                       $line_items = '[
        {
           
           
          
            "name": "Hard Drive",
            "description": "500GB, USB 2.0 interface 1400 rpm, protective hard case.",
            "item_order": 1,
            "bcy_rate": 120,
            "rate": 120,
            "quantity": 1,
            "unit": " ",
            "discount_amount": 0,
            "discount": 0,
           
            "item_total": 120
        }
    ]';
    
    
    $final_items = array();
    $item_to_hash='';
    
    foreach ($order->get_items() as $item_key => $item_values):

    ## Using WC_Order_Item methods ##

    // Item ID is directly accessible from the $item_key in the foreach loop or
    $item_id = $item_values->get_id();

    ## Using WC_Order_Item_Product methods ##

    $item_name = $item_values->get_name(); // Name of the product
    $item_type = $item_values->get_type(); // Type of the order item ("line_item")

    $product_id = $item_values->get_product_id(); // the Product id
    $product = $item_values->get_product(); // the WC_Product object

    ## Access Order Items data properties (in an array of values) ##
    $item_data = $item_values->get_data();

    $product_name = $item_data['name'];
    $product_id = $item_data['product_id'];
    $variation_id = $item_data['variation_id'];
    $quantity = $item_data['quantity'];
    $tax_class = $item_data['tax_class'];
    $line_subtotal = $item_data['subtotal'];
    $line_subtotal_tax = $item_data['subtotal_tax'];
    $line_total = $item_data['total'];
    $line_total_tax = $item_data['total_tax'];

   

    $item_to_hash = $item_to_hash.$product_id.$quantity.number_format((float)$product->price, 2, '.', '');
    
    
    $temp_array = array(
        "productSKU" => $product_id,
        "description" => 'Item ID: '.$product_id,
        
      

        "quantity" => $quantity,
        "price" =>  $product->price
        
        );
        
        
        array_push($final_items,$temp_array);
    
    

endforeach;
    
    
    
    
            $line_items = urlencode($line_items);
                      
            $json = json_encode($final_items);
            
           // $json = urlencode($json);
            
         //   $return = get_site_url().'/'.'?crosspay_api=1&qedama=5';
            
            $return = get_site_url().'/'.'wp-content/plugins/woocommerce-bill-gateway/done.php';
            
            if($mode=='live-p')
            $return_e = get_site_url().'/'.'wp-content/plugins/woocommerce-bill-gateway/routep.php';
            else
            $return_e = get_site_url().'/'.'wp-content/plugins/woocommerce-bill-gateway/route.php';
            
            $my_options = get_option( 'my_option_name' );
            $merchCode =  urlencode($my_options['merchant_code']);
            $lang=$my_options['lang'];
            
            $securty_codee = $my_options['security_key'];
            
            $mode=$my_options['mode'];
            
            if($lang=='' or $lang=='ar')
            $lang='ar-eg';
            else
            {
            $lang='en-gb';
            }
            
            
            if($mode=='' or $mode=='live')
            $pre_url='https://crosspayonline.com/api/saveInvoice';
            else
            {
            $pre_url='https://crosspayonline.com/api/saveInvoice';
            }
            
            
            
          
           
           
           $final_arr = array();
           $final_arr['language']=$lang;
           $final_arr['merchantCode']=$merchCode;
           $final_arr['merchantRefNumber']=$order_id;

            
            $sig=hash('sha256',$merchCode.$order_id.$item_to_hash.'2'.$securty_codee);
            
            
            $re_url=$return_e;
            
            $bill_url = 'https://crosspayonline.com/api/saveInvoiceApiKey?api_data=82e4b4fd3a16ad99229af9911ce8e6d2&invoice_id='.$order_id.'&apiKey='.$securty_codee.'&total='.$total_bill.'&currency=USD&inv_details={"inv_items": [{"name": "Shoping from store","quntity": "1.00","unitPrice": "'.$total_bill.'","totalPrice": "'.$total_bill.'","currency": "USD"}],"inv_info":[{"row_title":"Vat","row_value":"0"},{"row_title":"Delevery","row_value":"0"},{"row_title":"Promo Code","row_value":0},{"row_title":"Discounts","row_value":0}],"user" :{"userName":"test"}}&return_url='.$re_url;
            $bill_url='https://crosspayonline.com/api/createInvoiceByAccount?api_data=82e4b4fd3a16ad99229af9911ce8e6d2&invoice_id='.$order_id.'&apiKey='.$securty_codee.'&total='.$total_bill.'&currency=USD&inv_details={"inv_items": [{"name": "Shoping from store","quntity": "1.00","unitPrice": "'.$total_bill.'","totalPrice": "'.$total_bill.'","currency": "USD"}],"inv_info":[{"row_title":"Vat","row_value":"0"},{"row_title":"Delevery","row_value":"0"},{"row_title":"Promo Code","row_value":0},{"row_title":"Discounts","row_value":0}],"user" :{"userName":"test"}}&return_url='.$re_url.'&email='.$c_email.'&mobile='.$c_mobile.'&name='.$c_name;
            
           $url= $pre_url.'/ECommercePlugin/plugin.jsp?merchant='.$merchCode.'&lang='.$lang.'&merchantRefNum='.$order_id.'&customerName='.$to_name.'&mobile=010xxxxxxx&email='.$email.'&order='.$json.'&redirectToURL='.$return;
		
		
		    $json_pass = '{ "language":"'.$lang.'", "merchantCode":"'.$merchCode.'", "merchantRefNumber":"'.$order_id.'", "customer":{ "name":"'.$to_name.'", "mobile":"010xxxxxxx", "email":"'.$email.'" }, "order":{ "description":"Order ID: '.$order_id.'", "expiry":"2", "orderItems":'.$json.' }, "signature":"'.$sig.'"}';
		
		    
		
	    	$url = $pre_url.'/ECommercePlugin/crosspay.jsp?chargeRequest='.$json_pass.'&successPageUrl='.$return.'&failerPageUrl='.$return_e;
			
			
			// Mark as on-hold (we're awaiting the payment)
			$order->update_status( 'on-hold', __( 'Awaiting offline payment', 'wc-gateway-offline' ) );
			
			// Reduce stock levels
			$order->reduce_order_stock();
			
			
			
			// Remove cart
			WC()->cart->empty_cart();
			
			// Return thankyou redirect
			return array(
				'result' 	=> 'success',
				'redirect'	=> $bill_url
			);
		}
	
  } // end \WC_Gateway_Offline class
}







class MySettingsPage
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'page_init' ) );
    }

    /**
     * Add options page
     */
    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_options_page(
            'crosspay Settings', 
            'crosspay Settings', 
            'manage_options', 
            'my-setting-admin', 
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page()
    {
        // Set class property
        $this->options = get_option( 'my_option_name' );
        
       
        ?>
        <div class="wrap">
            <h1>crosspayonline.com Payment Gateway Pay Settings</h1>
            <hr>
            <img width=250 src="https://trello-attachments.s3.amazonaws.com/5c8cfcadfb40d580f62c6d04/512x512/07ee9c8f2e141b77d739edff3a6aa002/biz_logo.png" >
            <hr>
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'my_option_group' );
                do_settings_sections( 'my-setting-admin' );
                submit_button();
            ?>
            <hr>
            <p><small>Develop by MTC (info@mtc.ps)</small></p>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function page_init()
    {        
        register_setting(
            'my_option_group', // Option group
            'my_option_name', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );
        
        
         add_settings_section(
            'mode', // ID
            'Mode: ', // Title
            array( $this, 'mode_callback' ), // Callback
            'my-setting-admin', // Page
            'setting_section_id' // Section         
        );  
        
        
        add_settings_section(
            'lang', // ID
            'crosspay UI Language: ', // Title
            array( $this, 'lang_callback' ), // Callback
            'my-setting-admin', // Page
            'setting_section_id' // Section         
        );  
        

        add_settings_section(
            'setting_section_id', // ID
            'Your Bill Pay Merchant Setting: ', // Title
            array( $this, 'print_section_info' ), // Callback
            'my-setting-admin' // Page
        );  

        add_settings_field(
            'merchant_code', // ID
            'Bill Main Email Address:', // Title 
            array( $this, 'id_number_callback' ), // Callback
            'my-setting-admin', // Page
            'setting_section_id' // Section           
        );      

        add_settings_field(
            'security_key', 
            'API key:', 
            array( $this, 'title_callback' ), 
            'my-setting-admin', 
            'setting_section_id'
        );      
    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function sanitize( $input )
    {
        $new_input = array();
        if( isset( $input['merchant_code'] ) )
            $new_input['merchant_code'] = sanitize_text_field( $input['merchant_code'] );

        if( isset( $input['security_key'] ) )
            $new_input['security_key'] = sanitize_text_field( $input['security_key'] );
            
        if( isset( $input['mode'] ) )
            $new_input['mode'] = sanitize_text_field( $input['mode'] ); 
            
            if( isset( $input['lang'] ) )
            $new_input['lang'] = sanitize_text_field( $input['lang'] ); 

        return $new_input;
    }

    /** 
     * Print the Section text
     */
    public function print_section_info()
    {
        print '';
    }

    /** 
     * Get the settings option array and print one of its values
     */
    public function id_number_callback()
    {
        printf(
            '<input type="text" id="merchant_code" name="my_option_name[merchant_code]" value="%s" />',
            isset( $this->options['merchant_code'] ) ? esc_attr( $this->options['merchant_code']) : ''
        );
    }
    
     public function mode_callback()
    {
       
       ?>
<select name="my_option_name[mode]">
  <option <?php if(esc_attr($this->options['mode'])=='' or esc_attr($this->options['mode'])=='live-p') print 'selected'  ?>  value="live-p">Live - Waiting Bill Approval</option>
    <option <?php if(esc_attr($this->options['mode'])=='' or esc_attr($this->options['mode'])=='live') print 'selected'  ?>  value="live">Live - Direct Realtime Payment Update</option>

  <option <?php if( esc_attr($this->options['mode'])=='sandbox') print 'selected'  ?> value="sandbox">Sandbox</option>
</select>
<hr>
<p>
<b>Live - Waiting Bill Approval: </b> (best security option): Our system will inform you of any successful transactions but will never pass any update to your website without getting approval. *Approval need from 24 to 72 business hours.
</p>
<p>
    <b>Live - Direct Real-time Payment Update: </b> (Low-Security Option) : Our System will pass all success payments to your website without check real bank statement, it means that you get a real-time status for payment without waiting for your transaction if reviewed by Bill and Bank Staff. (Please keep in mind that any successful transaction doesn't mean that you will get money in your wallet)
    </p>
    
    <hr>


       <?php
    }
    
    
    public function lang_callback()
    {
       
       ?>
<select name="my_option_name[lang]">
  <option <?php if(esc_attr($this->options['lang'])=='' or esc_attr($this->options['lang'])=='ar') print 'selected'  ?>  value="ar">Arabic</option>
  <option <?php if( esc_attr($this->options['lang'])=='en') print 'selected'  ?> value="en">English</option>
</select>
<hr>
       <?php
    }

    /** 
     * Get the settings option array and print one of its values
     */
    public function title_callback()
    {
        printf(
            '<input type="text" id="security_key" name="my_option_name[security_key]" value="%s" />',
            isset( $this->options['security_key'] ) ? esc_attr( $this->options['security_key']) : ''
        );
    }
}

if( is_admin() )
    $my_settings_page = new MySettingsPage();
    
    
