<?php
class ControllerPaymentBillPayment extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('payment/bill_payment');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('bill_payment', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');
           
		    $this->redirect(HTTPS_SERVER . 'index.php?route=extension/payment&token=' . $this->session->data['token']);
			 
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
		$this->data['text_authorization'] = $this->language->get('text_authorization');
		$this->data['text_sale'] = $this->language->get('text_sale');

		 
    $this->data['entry_api'] = $this->language->get('entry_api');
    $this->data['entry_password'] = $this->language->get('entry_password');
    $this->data['entry_currency'] = $this->language->get('entry_currency');
    $this->data['entry_email'] = $this->language->get('entry_email');
    $this->data['entry_telephone'] = $this->language->get('entry_telephone');
 
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

       if (isset($this->error['apipassword'])) {
			$this->data['error_apipassword'] = $this->error['apipassword'];
		} else {
			$this->data['error_apipassword'] = '';
		}

     


if (isset($this->error['api'])) {
			$this->data['error_api'] = $this->error['api'];
		} else {
			$this->data['error_api'] = '';
		}
		
		$this->data['breadcrumbs'] = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=extension/payment&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);
		
		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=payment/bill_payment&token=' . $this->session->data['token'],
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

	

		//$this->data['action'] = $this->url->link('payment/bill_payment', 'token=' . $this->session->data['token'], 'SSL');

		//$this->data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['bill_payment_email'])) {
			$this->data['bill_payment_email'] = $this->request->post['bill_payment_email'];
		} else {
			$this->data['bill_payment_email'] = $this->config->get('bill_payment_email');
		}
		if (isset($this->request->post['bill_payment_telephone'])) {
			$this->data['bill_payment_telephone'] = $this->request->post['bill_payment_telephone'];
		} else {
			$this->data['bill_payment_telephone'] = $this->config->get('bill_payment_telephone');
		}

    if (isset($this->request->post['bill_payment_api'])) {
			$this->data['bill_payment_api'] = $this->request->post['bill_payment_api'];
		} else {
			$this->data['bill_payment_api'] = $this->config->get('bill_payment_api');
		}

    if (isset($this->request->post['bill_payment_apipassword'])) {
			$this->data['bill_payment_apipassword'] = $this->request->post['bill_payment_apipassword'];
		} else {
			$this->data['bill_payment_apipassword'] = $this->config->get('bill_payment_apipassword');
		}

    if (isset($this->request->post['bill_payment_currency'])) {
			$this->data['bill_payment_currency'] = $this->request->post['bill_payment_currency'];
		} else {
			$this->data['bill_payment_currency'] = $this->config->get('bill_payment_currency');
		}

		$this->load->model('localisation/order_status');

		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['bill_payment_geo_zone_id'])) {
			$this->data['bill_payment_geo_zone_id'] = $this->request->post['bill_payment_geo_zone_id'];
		} else {
			$this->data['bill_payment_geo_zone_id'] = $this->config->get('bill_payment_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['bill_payment_status'])) {
			$this->data['bill_payment_status'] = $this->request->post['bill_payment_status'];
		} else {
			$this->data['bill_payment_status'] = $this->config->get('bill_payment_status');
		}

    
		if (isset($this->request->post['bill_payment_sort_order'])) {
			$this->data['bill_payment_sort_order'] = $this->request->post['bill_payment_sort_order'];
		} else {
			$this->data['bill_payment_sort_order'] = $this->config->get('bill_payment_sort_order');
		}
  
		$this->template = 'payment/bill_payment.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		//$this->response->setOutput($this->render());
		
		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/bill_payment')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

         if (!$this->request->post['bill_payment_api']) {
			$this->error['api'] = $this->language->get('error_api');
		}
		 if (!$this->request->post['bill_payment_apipassword']) {
			$this->error['apipassword'] = $this->language->get('error_apipassword');
		}
		
		if ($this->request->post['bill_payment_status']== 1) {
			
			 $apiID = $this->request->post['bill_payment_api'];
             $apiData =$this->request->post['bill_payment_apipassword'];
 
 
  
 
 /*
 
             $curl = curl_init();
             curl_setopt_array($curl, array(
             CURLOPT_URL => "http://www.crosspayonline.com/api/loginBill",
             CURLOPT_RETURNTRANSFER => true,
             CURLOPT_ENCODING => "",
             CURLOPT_MAXREDIRS => 10,
             CURLOPT_TIMEOUT => 30,
             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
             CURLOPT_CUSTOMREQUEST => "POST",
             CURLOPT_POSTFIELDS => "apiKey=account_apiKey&api_data=82e4b4fd3a16ad99229af9911ce8e6d2",
             CURLOPT_HTTPHEADER => array(
                    "accept: application/json",
                    "content-type: application/json"
                  ),
            ));
			
           $response = curl_exec($curl);
		    $datta = json_decode($response);
		 	
			
			
           $err = curl_error($curl);
           curl_close($curl);
            if ($datta->msg !="") { 
			$this->error['apipassword'] =   " Error #:" .$datta->msg;
		    } */
        }
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>